/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class LDAPDN {
    public static String[] explodeDN(String string, boolean bl) {
        DN dN = new DN(string);
        return dN.explodeDN(bl);
    }

    public static String[] explodeRDN(String string, boolean bl) {
        RDN rDN = new RDN(string);
        if (bl) {
            return rDN.getValues();
        }
        String[] stringArray = new String[]{rDN.toString()};
        return stringArray;
    }

    public static String escapeRDN(String string) {
        RDN rDN = new RDN(string);
        String[] stringArray = rDN.getValues();
        if (stringArray == null) {
            return string;
        }
        StringBuffer[] stringBufferArray = new StringBuffer[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = rDN.getTypes();
        int n = 0;
        while (n < stringArray.length) {
            stringBufferArray[n] = new StringBuffer(stringArray[n]);
            int n2 = 0;
            while (n2 < stringBufferArray[n].length()) {
                if (LDAPDN.isEscape(stringBufferArray[n].charAt(n2))) {
                    stringBufferArray[n].insert(n2, '\\');
                    ++n2;
                }
                ++n2;
            }
            stringBuffer.append(String.valueOf(stringBuffer.length() > 0 ? " + " : "") + stringArray2[n] + "=" + new String(stringBufferArray[n]));
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String unEscapeRDN(String string) {
        RDN rDN = new RDN(string);
        String[] stringArray = rDN.getValues();
        if (stringArray == null || stringArray.length < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c != '\\') {
                stringBuffer2.append(c);
            }
            ++n;
        }
        return String.valueOf(rDN.getTypes()[0]) + "=" + new String(stringBuffer2);
    }

    public static String normalize(String string) {
        return new DN(string).toString();
    }

    public static boolean equals(String string, String string2) {
        return LDAPDN.normalize(string).equals(LDAPDN.normalize(string2));
    }

    private static boolean isEscape(char c) {
        int n = 0;
        while (n < DN.ESCAPED_CHAR.length) {
            if (c == DN.ESCAPED_CHAR[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

